{------------------------------------------------------------------------------}
{ TSaveListView v1.21 (c) 1998-99 Y-Tech Corporation       February 26th, 1999 }
{------------------------------------------------------------------------------}
{ TSaveListView saves the contents of any ListView. If you want, it can also   }
{ handle all Open & Save Dialogs, Disabling of Buttons & Menu Items, etc. so   }
{ you can make a complete Application with a TListView in almost no time.      }
{ Shows Progress.                                                              }
{                                                                              }
{ Please visit our Web Site: http://www.igather.com/components to try out the  }
{ many other freeware and shareware components and classes available there.    }
{------------------------------------------------------------------------------}

{------------------------------------------------------------------------------}
{ Installation                                                                 }
{------------------------------------------------------------------------------}
{ Please register SaveLVReg.pas                                                }
{                                                                              }
{ Important! Since many Y-Tech Components (ie. those made by Y-Tech Corp.)     }
{ share the same units, you must put all code files (.dcu, .pas, .dfm,         }
{ .dcr, etc...) for all Y-Tech Components into the same directory. Otherwise   }
{ Delphi will not compile the library/package properly.                        }
{------------------------------------------------------------------------------}

{------------------------------------------------------------------------------}
{ Important! Things to be aware of...                                          }
{------------------------------------------------------------------------------}
{ Various Y-Tech SaveIt components hook into many events, if you set any of    }
{ these at run-time please "hook" into them and don't just assign to them (ie. }
{ please remember to call the original event at then end of your event         }
{ procedure).                                                                  }
{                                                                              }
{ Here's a list of the events that currently get hooked, more events may be    }
{ hooked in future versions:                                                   }
{                                                                              }
{ - TApplication.OnMessage                                                     }
{ - TScreen.OnActiveFormChange  (TMDISaveIt Only)                              }
{ - TForm.OnActivate                                                           }
{ - TForm.OnCloseQuery                                                         }
{ - TForm.OnClose                                                              }
{ - TForm.OnDestroy                                                            }
{ - TForm.WindowProc            (Delphi 3 and Up only)                         }
{ - TListView.OnInsert          (TSaveListView Only)                           }
{ - TListView.OnDeletion        (TSaveListView Only)                           }
{------------------------------------------------------------------------------}

{------------------------------------------------------------------------------}
{ The TSaveIt Family of Components & Classes - You don't need to know this     }
{------------------------------------------------------------------------------}
{ TComponent                                          | Files Required by....  }
{ |                                                   |------------------------}
{ |- TCustomSaveIt           (CustSaveIt.pas)         |                        }
{ |  |- TAlmostSaveIt        (AlmostSave.pas)         | Class Files            }
{ |  |  |- TMultiSaveItType  (MultiSaveItReg.pas)  RC | ---------------------  }
{ |  |  |- TMDIChildSaveIt   (MDISaveItReg.pas)    RC | CustSaveItObj [All]    }
{ |  |                                                | SaveLView     [L]      }
{ |  |- TSaveListView        (SaveLVReg.pas)       RC | SuperStrList  [L]      }
{ |                                                   |                        }
{ |- TGenericSaveIt          (GenericSave.pas)        | Abstract Components    }
{ |  |- TMultiSaveIt         (MultiSaveItReg.pas)  RC | ---------------------  }
{ |  |- TMDISaveIt           (MDISaveItReg.pas)    RC | CustSaveIt    [All]    }
{ |                                                   | AlmostSave    [M,D]    }
{ |- TGenericSaveItType      (GenericSave.pas)        | GenericSave   [M,D]    }
{    |- TMDISaveItType       (MDISaveItReg.pas)    RC |                        }
{    |                                                | Registered Components  }
{    |- TGenericSaveItGroup  (GenericSave.pas)        | ---------------------  }
{       |- TMDISaveItGroup   (MDISaveItReg.pas)    RC | SaveLViewReg   [L]     }
{       |- TMultiSaveItGroup (MultiSaveItReg.pas)  RC | MultiSaveItReg [M]     }
{                                                     | MDISaveItReg   [D]     }
{ TObject                                             |                        }
{ |                                                   | Form Files (pas, dfm)  }
{ |- TCustomSaveItObject     (CustSaveItObj.pas)      | ---------------------  }
{    |- TSaveCompObject      (AlmostSave.pas)         | NewDlg        [M,D]    }
{    |- TSaveLView           (SaveLView.pas)          | Progress      [All]    }
{                                                     |                        }
{                                                     | Include Files (inc)    }
{                                                     | -------------------    }
{                                                     | CompConditionals [All] }
{                                                     | CompConstants    [All] }
{------------------------------------------------------------------------------}
{ Legend:                                                                      }
{   RC  = Registerable Component (ie. a finished product)                      }
{   L   = TSaveListView                                                        }
{   M   = TMultiSaveIt                                                         }
{   D   = TMDISaveIt                                                           }
{------------------------------------------------------------------------------}

{------------------------------------------------------------------------------}
{ Questions & Comments                                                         }
{------------------------------------------------------------------------------}
{ All questions and comments should be sent to ycomp@hotpop.com                }
{------------------------------------------------------------------------------}

{------------------------------------------------------------------------------}
{ Usage                                                                        }
{------------------------------------------------------------------------------}
{ - Always read "readme.txt"                                                   }
{ - Please look at "info.htm"                                                  }
{ - Please refer to the help file.                                             }
{------------------------------------------------------------------------------}

{------------------------------------------------------------------------------}
{ Freeware License Agreement & Disclaimer                                      }
{------------------------------------------------------------------------------}
{ By use of this component, you have agreed to the following:                  }
{                                                                              }
{ You may not not distribute the source for this component, you may only       }
{ distribute the freeware with no source version. (The source zip will have    }
{ no .dcu files in it, the one with no source will have .dcu files)            }
{                                                                              }
{ Also, you may only distribute the unmodified .Zip file of the Freeware with  }
{ No Source version of this component. The .Zip file mentioned is the .Zip     }
{ file that this file you are currently reading came in. Other than that, you  }
{ are free to distribute this component.                                       }
{                                                                              }
{ Although this component has been thoroughly tested and documented, neither   }
{ Y-Tech Corporation nor any of it's employees nor the author will be held     }
{ responsible for any damage arising from it's use or misuse.                  }
{------------------------------------------------------------------------------}
                                        
{------------------------------------------------------------------------------}
{ Known Bugs - (B) = Bug, (W) = Workaround                                     }
{------------------------------------------------------------------------------}
{ (B): The sender property doesn't always work properly in any of the Save It  }
{      components.                                                             }
{ (W): Just Ignore it until I get it fixed.                                    }
{------------------------------------------------------------------------------}

{------------------------------------------------------------------------------}
{ Revision History                                                             }
{------------------------------------------------------------------------------}
{ 1.00: + Initial Release                                                      }
{ 1.10: + Fixed various minor bugs                                             }
{       + Fixed "ListView Not Assigned" bug. (If you did not assign a listview }
{         the first time you dropped the component on the form, then when you  }
{         closed and reopened the project it would generate an exception and   }
{         your project would generate an error message and not show the        }
{         TSaveListView component.                                             }
{       + Drastically changed interface including names of events and methods. }
{ 1.11: + Fixed Access Violation when removing the ListView from the form.     }
{ 1.20: + First Freeware Release.                                              }
{ 1.21: + [major bux fix] v1.20 still thought it was Shareware and only worked }
{         under IDE. oops.                                                     }
{       + [major bug fix] Sometimes an application using TSaveListView would   }
{         get an Access Violation on closing.                                  }
{       + [major bug fix] If you used the Object Inspector to delete the name  }
{         of the assigned ListView then it would cause an Access Violation.    }
{------------------------------------------------------------------------------}

unit SaveLVReg;

interface

uses
  Classes,

  // TSaveListView units
  SaveLV;

const
  {$I CompConstants.inc} // Component Constants

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents(cComponentTab, [TSaveListView]);
end;

end.
